function [XandCI] = CalErr(X, Y, q,b0,b1,YExp)

%{
This m-file belongs to the article 'The role of the electrolyte identity on
electrochemical CO2 conversion in the absence of mass transfer limitations'
Authors: Anne Sustronk (1,2) , Nieck E. Benes (1) , Guido Mul (2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to provide for the input required to plot Figures 1, 3 and
4 of the article.

The file requires input from ConstantPotential.m, or ConstantCurrent.m
for execution.

This file is used by Fig1AndFig4.m, Fig3aAndS2.m and Fig3bAndS3.m.

Note that the file location in ConstantPotential.m (lines 4, 28, 33 and
37) should be added before execution of Fig1And4.m

Note that the file location in ConstantCurrent.m (lines 46, 52, and 59)
should be added before execution of Fig3aAndS2.m.

Version date m-file: Feb 22, 2023
%}

% Remove NaN from Y vector
Y(isnan(Y)) = [];

% Amount of data points in calibration
n = length(X);

% Calculate estimated value
Yhat = b0+b1.*X;

%% Calculate mean, error sum of squares and mean square error of calibration
XAvg = mean(X);
YAvg = mean(Y);
S_XX = sum(X.^2)-length(X)*XAvg.^2;
s_2 = sum((Y-Yhat).^2)/(n-1);

%% Calculate standard deviation of X estimated from Y
% Estimate X from Y (Inverse regression)
XEstim = (YExp-b0)/b1;

% Calculate standard deviation of the experimental value(s)
SD = 1/b1.*sqrt(s_2.*((1./q)+(1/n)+(YExp-YAvg).^2/(b1.^2.*S_XX)));

%% Display results

XandCI = [XEstim' SD'];

end
